<?php
/*
Plugin Name: FIX IT
Plugin URI: https://spc.landing4biz.com/
Description: תוסף לניהול הגדרות FIX ב-WooCommerce עם אפשרויות הרכבה וקטגוריות.
Version: 1.0
Author: Your Name
Author URI: https://yourwebsite.com/
License: GPL2
Text Domain: fix-it
*/

// הגנה על הקובץ מפני גישה ישירה
if (!defined('ABSPATH')) {
    exit;
}

// הוספת עמוד ניהול "הגדרת FIX" בתפריט הצדדי של WordPress
function fix_add_menu_page() {
    add_menu_page(
        'הגדרת FIX',
        'הגדרת FIX',
        'manage_options',
        'fix-settings',
        'fix_render_settings_page',
        'dashicons-admin-tools',
        20
    );
}
add_action('admin_menu', 'fix_add_menu_page');

// הפונקציה שתציג את תוכן עמוד הניהול
function fix_render_settings_page() {
    echo '<div class="wrap"><h1>הגדרת FIX</h1>';

    for ($i = 1; $i <= 10; $i++) {
        $saved_category_id = get_option('fix_category_' . $i);
        $saved_price = get_option('fix_price_' . $i);

        echo '
        <div class="fix-category-box">
            <label>קטגוריה ' . $i . '</label>
            <div class="category-select">
                ' . wp_dropdown_categories(array(
                    'show_option_none' => 'בחר קטגוריה',
                    'taxonomy' => 'product_cat',
                    'hide_empty' => false,
                    'echo' => false,
                    'selected' => esc_attr($saved_category_id),
                    'name' => 'category_select_' . $i,
                    'id' => 'category_select_' . $i,
                    'class' => 'category-select-field'
                )) . '
                <input type="number" step="0.01" min="0" name="assembly_price_' . $i . '" id="assembly_price_' . $i . '" placeholder="מחיר הרכבה" class="assembly-price-field" value="' . esc_attr($saved_price) . '" />
                <button class="save-category-button button" data-index="' . esc_attr($i) . '">שמור</button>
                <button class="remove-category-button button" data-index="' . esc_attr($i) . '"' . ($saved_category_id ? '' : ' style="display:none;"') . '>הסר קטגוריה</button>
            </div>
        </div>';
    }

    echo '</div>';
}

// הוספת סקריפטים מותאמים אישית לעמוד הניהול
function fix_load_admin_scripts() {
    wp_enqueue_script('fix-settings-script', plugin_dir_url(__FILE__) . 'fix-settings.js', array('jquery'), null, true);
    wp_localize_script('fix-settings-script', 'fixSettingsAjax', array('ajaxurl' => admin_url('admin-ajax.php')));
    wp_enqueue_style('fix-settings-style', plugin_dir_url(__FILE__) . 'fix-settings.css');
}
add_action('admin_enqueue_scripts', 'fix_load_admin_scripts');

// AJAX לשמירת קטגוריה ומחיר הרכבה עם הגנה
function fix_save_category_ajax() {
    check_ajax_referer('fix_save_category', 'security');
    
    $category_id = intval($_POST['category_id']);
    $assembly_price = floatval($_POST['assembly_price']);
    $index = intval($_POST['index']);

    if ($category_id && $assembly_price >= 0 && $index > 0 && $index <= 10) {
        update_option('fix_category_' . $index, $category_id);
        update_option('fix_price_' . $index, $assembly_price);
        wp_send_json_success('הקטגוריה והמחיר נשמרו בהצלחה.');
    } else {
        wp_send_json_error('שגיאה: אנא בחר קטגוריה והזן מחיר חוקי.');
    }
}
add_action('wp_ajax_fix_save_category', 'fix_save_category_ajax');

// AJAX להסרת קטגוריה ומחיר הרכבה עם הגנה
function fix_remove_category_ajax() {
    check_ajax_referer('fix_remove_category', 'security');
    
    $index = intval($_POST['index']);

    if ($index > 0 && $index <= 10) {
        delete_option('fix_category_' . $index);
        delete_option('fix_price_' . $index);
        wp_send_json_success();
    } else {
        wp_send_json_error('שגיאה: לא ניתן למחוק את הנתונים.');
    }
}
add_action('wp_ajax_fix_remove_category', 'fix_remove_category_ajax');

// JavaScript מותאם אישית עם הגנה
add_action('admin_footer', function() {
    if (get_current_screen()->id === 'toplevel_page_fix-settings') {
        wp_nonce_field('fix_save_category', 'fix_save_category_nonce');
        wp_nonce_field('fix_remove_category', 'fix_remove_category_nonce');
        echo '
        <script type="text/javascript">
        jQuery(document).ready(function($) {
            $(".save-category-button").click(function() {
                var index = $(this).data("index");
                var selectedCategory = $("#category_select_" + index).val();
                var assemblyPrice = $("#assembly_price_" + index).val();

                if (selectedCategory && assemblyPrice) {
                    $.ajax({
                        url: fixSettingsAjax.ajaxurl,
                        type: "POST",
                        data: {
                            action: "fix_save_category",
                            security: $("#fix_save_category_nonce").val(),
                            category_id: selectedCategory,
                            assembly_price: assemblyPrice,
                            index: index
                        },
                        success: function(response) {
                            if (response.success) {
                                $("#category_select_" + index).prop("disabled", true);
                                $("#assembly_price_" + index).prop("disabled", true);
                                $(".remove-category-button[data-index=\'" + index + "\']").show();
                                alert(response.data);
                            } else {
                                alert(response.data);
                            }
                        }
                    });
                } else {
                    alert("אנא בחר קטגוריה והזן מחיר הרכבה.");
                }
            });

            $(".remove-category-button").click(function() {
                var index = $(this).data("index");
                $.ajax({
                    url: fixSettingsAjax.ajaxurl,
                    type: "POST",
                    data: {
                        action: "fix_remove_category",
                        security: $("#fix_remove_category_nonce").val(),
                        index: index
                    },
                    success: function(response) {
                        if (response.success) {
                            $("#category_select_" + index).val("").prop("disabled", false);
                            $("#assembly_price_" + index).val("").prop("disabled", false);
                            $(this).hide();
                            alert("הקטגוריה והמחיר נמחקו בהצלחה.");
                        } else {
                            alert("שגיאה: לא ניתן למחוק את הנתונים.");
                        }
                    }
                });
            });
        });
        </script>';
    }
});

// CSS מותאם אישית
add_action('admin_head', function() {
    if (get_current_screen()->id === 'toplevel_page_fix-settings') {
        echo '
        <style type="text/css">
        .fix-category-box {
            margin-bottom: 20px;
        }
        .category-select {
            display: flex;
            align-items: center;
        }
        .category-select select {
            max-width: 200px;
        }
        .assembly-price-field {
            margin-left: 10px;
            max-width: 100px;
        }
        .save-category-button {
            margin-left: 10px;
        }
        .remove-category-button {
            margin-left: 10px;
        }
        </style>';
    }
});

// הוספת אפשרות בחירה למוצרים
function fix_add_assembly_option_to_product() {
    global $product;

    if ($product->is_type('simple')) {
        $categories = wp_get_post_terms($product->get_id(), 'product_cat');
        $show_option = false;
        $assembly_price = 0;

        foreach ($categories as $category) {
            for ($i = 1; $i <= 10; $i++) {
                $saved_category_id = get_option('fix_category_' . $i);
                if ($saved_category_id == $category->term_id) {
                    $assembly_price = floatval(get_option('fix_price_' . $i));
                    $show_option = true;
                    break 2;
                }
            }
        }

        if ($show_option) {
            echo '<div class="fix-assembly-option">';
            echo '<label for="fix_assembly_select">בחר אפשרות הרכבה:</label>';
            echo '<select id="fix_assembly_select" name="fix_assembly_select">';
            echo '<option value="without" selected>בלי הרכבה</option>';
            echo '<option value="with" data-price="' . esc_attr($assembly_price) . '">עם הרכבה (+₪' . number_format($assembly_price, 2) . ')</option>';
            echo '</select>';
            echo '</div>';

            // הוספת JavaScript כדי לעדכן את המחיר בזמן אמת
            echo '
            <script type="text/javascript">
            jQuery(document).ready(function($) {
                $("#fix_assembly_select").change(function() {
                    var selectedOption = $(this).find("option:selected");
                    var price = parseFloat(selectedOption.data("price"));
                                       var originalPrice = ' . $product->get_price() . ';

                    if ($(this).val() == "with") {
                        var newPrice = originalPrice + price;
                        $(".woocommerce-Price-amount").text(newPrice.toFixed(2) + " ₪");
                    } else {
                        $(".woocommerce-Price-amount").text(originalPrice.toFixed(2) + " ₪");
                    }
                });
            });
            </script>';
        }
    }
}
add_action('woocommerce_before_add_to_cart_button', 'fix_add_assembly_option_to_product');

// הוספת מחיר ההרכבה למחיר המוצר בעת חישוב הסל
function fix_add_assembly_price($cart_object) {
    if (!WC()->session->__isset('reload_checkout')) {
        foreach ($cart_object->get_cart() as $cart_item) {
            if (isset($cart_item['fix_assembly_select']) && $cart_item['fix_assembly_select'] == 'with') {
                $product_id = $cart_item['product_id'];
                $categories = wp_get_post_terms($product_id, 'product_cat');

                foreach ($categories as $category) {
                    for ($i = 1; $i <= 10; $i++) {
                        $saved_category_id = get_option('fix_category_' . $i);
                        if ($saved_category_id == $category->term_id) {
                            $assembly_price = floatval(get_option('fix_price_' . $i));
                            if ($assembly_price) {
                                $cart_item['data']->set_price($cart_item['data']->get_price() + $assembly_price);
                                break 2;
                            }
                        }
                    }
                }
            }
        }
    }
}
add_action('woocommerce_before_calculate_totals', 'fix_add_assembly_price');

// שמירת בחירת ההרכבה למידע על המוצר בסל הקניות
function fix_add_assembly_option_to_cart_item_data($cart_item_data, $product_id, $variation_id) {
    if (isset($_POST['fix_assembly_select']) && $_POST['fix_assembly_select'] == 'with') {
        $cart_item_data['fix_assembly_select'] = 'with';
    }
    return $cart_item_data;
}
add_filter('woocommerce_add_cart_item_data', 'fix_add_assembly_option_to_cart_item_data', 10, 3);

// הצגת מידע ההרכבה בסל הקניות ובעמוד ההזמנה
function fix_display_assembly_option_in_cart($item_data, $cart_item) {
    if (isset($cart_item['fix_assembly_select']) && $cart_item['fix_assembly_select'] == 'with') {
        $item_data[] = array(
            'name' => '',  // לא להציג שם
            'value' => '<p>עם הרכבה</p>'  // הצגת הערך עם תגית p
        );
    }
    return $item_data;
}
add_filter('woocommerce_get_item_data', 'fix_display_assembly_option_in_cart', 10, 2);

// שמירת מחיר ההרכבה בעת טעינת הסל מחדש
function fix_get_cart_item_from_session($cart_item, $values) {
    if (isset($values['fix_assembly_select'])) {
        $cart_item['fix_assembly_select'] = $values['fix_assembly_select'];

        // עדכון המחיר אם "עם הרכבה" נבחר
        if ($cart_item['fix_assembly_select'] == 'with') {
            $categories = wp_get_post_terms($cart_item['product_id'], 'product_cat');

            foreach ($categories as $category) {
                for ($i = 1; $i <= 10; $i++) {
                    $saved_category_id = get_option('fix_category_' . $i);
                    if ($saved_category_id == $category->term_id) {
                        $assembly_price = floatval(get_option('fix_price_' . $i));
                        if ($assembly_price) {
                            $cart_item['data']->set_price($cart_item['data']->get_price() + $assembly_price);
                            break 2;
                        }
                    }
                }
            }
        }
    }
    return $cart_item;
}
add_filter('woocommerce_get_cart_item_from_session', 'fix_get_cart_item_from_session', 20, 2);

// חסימת גישה לקבצי ה-XML-RPC
add_filter('xmlrpc_enabled', '__return_false');

// הגנה מפני XSS בהגדרות
function fix_escape_admin_output($input) {
    return esc_html($input);
}

// הגנה מפני SQL Injection בעמודי הגדרות
function fix_validate_input($input) {
    global $wpdb;
    return $wpdb->remove_placeholder_escape($input);
}
?>

